# EG11-12 Kompletny sklep Modny ciuch

import pickle

from BTCInput import *

class StockItem(object):
    '''
    Towar magazynowy dla sklepu z odzieżą
    '''

    show_instrumentation = False
    
    min_price = 0.5 
    max_price = 500.0 

    max_stock_add = 50

    def __init__(self, stock_ref, price, color, location):
        if StockItem.show_instrumentation:
            print('** Wywołano StockItem __init__')
        self.stock_ref = stock_ref
        self.__price = price
        self.__stock_level = 0
        self.StockItem_version = 1
        self.color = color
        self.location = location

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy StockItem')
        return 'Towar magazynowy'
        
    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy StockItem')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        pass

    def __str__(self): 
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy StockItem')
        template = '''Numer magazynowy: {0}
Typ: {1}
Lokalizacja: {2}
Cena: {3}
Stan magazynowy: {4}
Kolor: {5}''' 

        return template.format(self.stock_ref, self.item_name, self.location,
                                self.price, self.stock_level, self.color) 

    def add_stock(self,count):
        '''
        Dodaje stan magazynowy dla tego produktu. 
        Count zawiera ilość towaru do dodania
        Zgłasza wyjątek, jeśli liczba jest nieprawidłowa
        '''
        if StockItem.show_instrumentation:
            print('** Wywołano metodę add_stock klasy StockItem')
        if count < 0 or count > StockItem.max_stock_add:
            raise Exception('Nieprawidłowa ilość towaru')

        self.__stock_level = self.__stock_level + count

    def sell_stock(self, count):
        '''
        Sprzedaż towaru.
        count zawiera liczbę towaru do sprzedania
        Zgłasza wyjątek, jeśli liczba jest nieprawidłowa
        '''
        if StockItem.show_instrumentation:
            print('** Wywołano metodę sell_stock klasy StockItem')
        if count < 1:
            raise Exception('Nieprawidłowa ilość towaru do sprzedaży')

        if count > self.stock_level:
            raise Exception('W magazynie nie ma wystarczającej ilości towaru')

        self.__stock_level = self.__stock_level - count

    def set_price(self, new_price):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę set_price klasy StockItem')
        if price < StockItem.min_price or price > StockItem.max_price:
            raise Exception('Cena poza zakresem')
        self.__price = new_price

    @property
    def price(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get price klasy StockItem')
        return self.__price

    @property
    def stock_level(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get stock_level klasy StockItem')
        return self.__stock_level


class Dress(StockItem):

    def __init__(self, stock_ref, price, color, pattern, size, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Dress')
        super().__init__(stock_ref=stock_ref, price=price,
                         color=color, location=location)
        self.pattern = pattern
        self.size = size
        self.Dress_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Dress')
        return 'Sukienka'
        
    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Dress')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Dress')
        stock_details = super().__str__()
        template = '''{0}
Fason: {1}
Rozmiar: {2}'''
        return template.format(stock_details, self.pattern,
                               self.size) 
 

class Pants(StockItem):

    def __init__(self, stock_ref, price, color, pattern, length, waist, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Pants')
        super().__init__(stock_ref=stock_ref, price=price,
                         color=color, location=location)
        self.pattern = pattern
        self.length = length
        self.waist = waist
        self.pants_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Pants')
        return 'Spodnie'

    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Pants')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Pants')
        stock_details = super().__str__()
        template = '''{0}
Fason: {1}
Długość:  {2}
Pas: {3}'''
        return template.format(stock_details, self.pattern,
                               self.length, self.waist) 


class Jeans(Pants):

    def __init__(self, stock_ref, price, color, pattern, length, waist, style, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Jeans')
        super().__init__(stock_ref=stock_ref, price=price,
                         color=color, pattern=pattern, length=length,
                         waist=waist, location=location)
        self.style = style
        self.Jeans_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Jeans')
        return 'Dżinsy'

    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Jeans')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Jeans')
        pants_details = super().__str__()
        template = '''{0}
Styl:  {1}'''
        return template.format(pants_details, self.style)


class Hat(StockItem):

    def __init__(self, stock_ref, price, color, size, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Hat')
        super().__init__(stock_ref=stock_ref, price=price,
                         color=color, location=location)
        self.size = size
        self.Hat_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Hat')
        return "Kapelusz" 

    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Hat')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Hat')
        stock_details = super().__str__()
        template = '''{0}
Rozmiar: {1}'''
        return template.format(stock_details, self.size)

class Blouse(StockItem):
    
    def __init__(self, stock_ref, price, color, size, style, pattern, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Blouse')
        super().__init__(stock_ref, price, color, location)
        self.size = size
        self.style = style
        self.pattern = pattern
        self.Hat_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Blouse')
        return "Bluza" 

    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Blouse')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Blouse')
        stock_details = super().__str__()
        template = '''{0}
Rozmiar: {1}
Styl:  {2}
Fason: {3}'''
        return template.format(stock_details, self.size,
                               self.style, self.pattern) 


import pickle


class FashionShop:

    show_instrumentation = False

    def __init__(self):
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę __init__ klasy FashionShop')
        self.__stock_dictionary = {}

    def save(self, filename):
        '''
        Zapisuje dane sklepu w pliku o podanej nazwie
        Dane są przechowywane w postaci binarnej, w pliku .pickle
        Jeśli zapis nie powiedzie się, program zgłosi wyjątki 
        '''
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę save klasy FashionShop')
        with open(filename,'wb') as out_file:
            pickle.dump(self,out_file)

    @staticmethod
    def load(filename):
        '''
        Ładuje dane sklepu z odzieżą z pliku o podanej nazwie
        Dane są przechowywane w postaci binarnej, w pliku .pickle
        Jeśli ładowanie pliku się nie powiedzie, funkcja będzie zgłaszała wyjątki
        '''
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę load klasy FashionShop')
        with open(filename,'rb') as input_file:
            result = pickle.load(input_file)

        # Teraz zaktualizuj wersje załadowanych towarów
        for stock_item in result.__stock_dictionary.values():
            stock_item.check_version()
        return result


    def store_new_stock_item(self, stock_item):
        '''
        Utwórz nowy towar w sklepie z odzieżą
        Towary są poindeksowane wg wartości stock_ref
        Zgłasza wyjątek, jeśli towar już 
        istnieje 
        '''
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę store_new_stock_item klasy FashionShop')
        if stock_item.stock_ref in self.__stock_dictionary:
            raise Exception('Towar już istnieje') 
        self.__stock_dictionary[stock_item.stock_ref] = stock_item


    def find_stock_item(self, stock_ref):
        '''
        Pobiera towar ze słownika
        Zwraca None, jeśli nie ma towaru dla
        tego klucza
        '''
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę find_stock_item klasy FashionShop')
        if stock_ref in self.__stock_dictionary:
            return self.__stock_dictionary[stock_ref]
        else:
            return None

    def __str__(self):
        if FashionShop.show_instrumentation:
            print('** Wywołano metodę __str__ klasy FashionShop')
        stock = map(str,self.__stock_dictionary.values())
        stock_list = '\n'.join(stock)
        template = '''Towary w magazynie

{0}
'''
        return template.format(stock_list)


class FashionShopShellApplication:

    def __init__(self, filename):
        '''
        Zarządza danymi sklepu z odzieżą
        Wyświetla komunikat, jeśli ładowanie się nie powiedzie i tworzy nowy sklep
        '''
        FashionShopShellApplication.__filename = filename
        try:
            self.__shop = FashionShop.load(filename)
        except:
            print('Nie załadowano danych sklepu z odzieżą.')
            print('Tworzenie pustego sklepu z odzieżą')
            self.__shop = FashionShop()

    def create_new_stock_item(self):
        '''
        Tworzy nowy towar magazynowy Pobiera szczegóły towaru, 
        tworzy go, a następnie zapisuje w sklepie
        '''
        def get_stock_details():
            '''
            Pobiera podstawowe dane o towarze magazynowym
            Zwraca słownik zawierający nazwy towarów
            '''
            result = {}
            result['stock_ref'] = read_text('Wprowadź numer magazynowy: ')
            result['price'] = read_float_ranged(prompt='Wprowadź cenę: ',
                                        min_value=StockItem.min_price,
                                        max_value=StockItem.max_price)
            result['color'] = read_text('Wprowadź kolor: ') 
            result['location'] = read_text('Wprowadź lokalizację: ')
            return result

        menu = '''
Utwórz nowy towar magazynowy 

1: Sukienka
2: Spodnie
3: Kapelusz
4: Bluza
5: Dżinsy

Jaki rodzaj towaru chcesz dodać: '''

        item = read_int_ranged(prompt=menu,min_value=1,max_value=5)
    
        if item == 1:
            print('Tworzenie sukienki')
            stock_details=get_stock_details()
            pattern = read_text('Wprowadź fason: ')
            size = read_text('Wprowadź rozmiar: ')
            stock_item =  Dress(stock_ref=stock_details['stock_ref'],
                                price=stock_details['price'],
                                color=stock_details['color'],
                                location=stock_details['location'],
                                pattern=pattern,    
                                size=size)
        elif item == 2:
            print('Tworzenie pary spodni')
            stock_details=get_stock_details()
            pattern = read_text('Wprowadź fason: ')
            length = read_text('Wprowadź długość: ')
            waist = read_text('Wprowadź pas: ')
            stock_item = Pants(stock_ref=stock_details['stock_ref'],
                                  price=stock_details['price'],
                                  color=stock_details['color'],
                                  location=stock_details['location'],
                                  pattern=pattern,
                                  length=length,
                                  waist=waist)
        elif item == 3:
            print('Tworzenie kapelusza')
            stock_details=get_stock_details()
            size = read_text('Wprowadź rozmiar: ')
            stock_item = Hat(stock_ref=stock_details['stock_ref'],
                             price=stock_details['price'],
                             color=stock_details['color'],
                             location=stock_details['location'],
                             size=size)
        elif item == 4:
            print('Tworzenie bluzy')
            stock_details=get_stock_details()
            size = read_text('Wprowadź rozmiar: ')
            style = read_text('Wprowadź styl: ')
            pattern = read_text('Wprowadź fason: ')
            stock_item = Blouse(stock_ref=stock_details['stock_ref'],
                                price=stock_details['price'],
                                color=stock_details['color'],
                                location=stock_details['location'],
                                pattern=pattern,
                                size=size,
                                style=style)
        elif item == 5:
            print('Tworzenie dżinsów')
            stock_details = get_stock_details()
            pattern = read_text('Wprowadź fason: ')
            length = read_text('Wprowadź długość: ')
            waist = read_text('Wprowadź pas: ')
            style = read_text('Wprowadź styl: ')
            stock_item = Jeans(stock_ref=stock_details['stock_ref'],
                               price=stock_details['price'],
                               color=stock_details['color'],
                               location=stock_details['location'],
                               pattern=pattern,
                               length=length,
                               waist=waist,
                               style=style)

        try:
            self.__shop.store_new_stock_item(stock_item)
            print('Towar zapisano')
        except Exception as e:
            print('Nie zapisano towaru')
            print(e)

    def add_stock(self):
        '''
        Dodaje towar do istniejącej pozycji magazynowej
        Najpierw wyszukuje towar, a następnie pobiera 
        liczbę pozycji towaru do dodania
        '''
        print('Dodaj towar')

        item_stock_ref = read_text('Wprowadź numer magazynowy: ')

        item = self.__shop.find_stock_item(item_stock_ref)
        
        if item == None:
            print('Nie znaleziono towaru')
            return

        print(item)

        number_to_add = read_int_ranged('Ilość towaru do dodania (0 aby zrezygnować): ',
                                        0, StockItem.max_stock_add)

        if number_to_add == 0:
            print('Nie dodano towaru')
        else:
            item.add_stock(number_to_add)
            print(item)

    def sell_stock(self):
        '''
        Sprzedaż towaru Najpierw wyszukuje towar, a następnie odczytuje
        liczbę sztuk towaru do sprzedaży.
        Nie pozwala na sprzedaż większej ilości towarów niż ma na stanie
        '''
        print('Sprzedaż towaru')

        item_stock_ref = read_text('Wprowadź numer magazynowy: ')

        item = self.__shop.find_stock_item(item_stock_ref)

        if item == None:
            print('Nie znaleziono towaru')
            return

        print('Sprzedaż')
        print(item)

        if item.stock_level == 0:
            print('Nie ma towarów w magazynie')
            return

        number_sold = read_int_ranged('Ilość towaru do sprzedaży (0 aby zrezygnować): ',
                                      0,
                                      item.stock_level)

        if number_sold == 0:
            print('Zrezygnowano ze sprzedaży')
            return

        item.sell_stock(number_sold)

        print('Sprzedano towar')

    def do_report(self):
        print('Raport magazynowy')
        print(self.__shop)

    def main_menu(self):

        prompt = '''Sklep Modny Ciuch

1: Utwórz nowy towar magazynowy
2: Dodaj zapas do istniejącej pozycji
3: Sprzedaj towar
4: Raport ze sprzedaży
5: Wyjście

Wprowadź polecenie: '''

        while(True):
            command = read_int_ranged(prompt, 1, 5)
            if command == 1:
                self.create_new_stock_item()
            elif command == 2:
                self.add_stock()
            elif command == 3:
                self.sell_stock()
            elif command == 4:
                self.do_report()
            elif command == 5:
                self.__shop.save(FashionShopShellApplication.__filename)
                print('Zapisano dane sklepu z odzieżą')
                break

ui = FashionShopShellApplication('dressshop1.pickle')
ui.main_menu()
       
        
